function Figure4B()
% This script plots the data from Figure 4B. The data is stored as a vector
% ('P') containing the aspect ratio for all particles. Data is grouped
% according to the vector 'G' for plotting via Matlab's 'boxplot' function.
% The variables 'mp' and 'mn' give the median values of aspect ratio for
% C3-positive particles (mp) and C3-negative particles (mn) for three
% biological replicates.

load Figure4B_data.mat

boxplot(P,G,'symbol',''); hold on;

dq = [-.1 0 .1];
plot(dq+1,mp(1,:),'g.','MarkerSize',24); hold on;
plot(dq+3,mp(2,:),'g.','MarkerSize',24);
plot(dq+5,mp(3,:),'g.','MarkerSize',24);
plot(dq+7,mp(4,:),'g.','MarkerSize',24);
plot(dq+9,mp(5,:),'g.','MarkerSize',24);

plot(dq+2,mn(1,:),'k.','MarkerSize',24);
plot(dq+4,mn(2,:),'k.','MarkerSize',24);
plot(dq+6,mn(3,:),'k.','MarkerSize',24);
plot(dq+8,mn(4,:),'k.','MarkerSize',24);
plot(dq+10,mn(5,:),'k.','MarkerSize',24);
ylim([0.8 7]);
xticks([1.5 3.5 5.5 7.5 9.5]);
xticklabels({'CR9501','5C4','Motav.','ADI-14353','ADI-14359'})
ylabel('Particle aspect ratio (L/W)');

[h,p] = ttest(mp(1,:),mn(1,:));
disp(['p-value for CR9501 comparison: ',num2str(p)]);
[h,p] = ttest(mp(2,:),mn(2,:));
disp(['p-value for 5C4 comparison: ',num2str(p)]);
[h,p] = ttest(mp(3,:),mn(3,:));
disp(['p-value for Motav. comparison: ',num2str(p)]);
[h,p] = ttest(mp(4,:),mn(4,:));
disp(['p-value for ADI-14353 comparison: ',num2str(p)]);
[h,p] = ttest(mp(5,:),mn(5,:));
disp(['p-value for ADI-14359 comparison: ',num2str(p)]);
